#adjust this to the folder that contains data files
setwd("/Users/ding/Documents/R/Main")

# transfer all the output to a file.
sink("output_analysisI_NormalDistributionTestResults", split = "TRUE")
R.version.string
sessionInfo()
# for more information, use R.Version()

cat("\n###############################################################################\n")
cat("\n# Analysis for the paper for International Journal of Human-Computer Studies: Virtual reality negotiation training system with exposure to simulated thoughts and conversations: Design and evaluation\n")
cat("\n# 2018 TUDelft\n")
cat("\n# Output file: output_analysisI_NormalDistributionTestResults will be created \n")
cat("\n# Author: Ding Ding \n")
cat("\n# required datafile from Data preparation I&II\n")
cat("\n# - DemographyData.csv\n")
cat("\n# - SE_With aLL sessions.csv\n")
cat("\n# - SE_CompareWL&EX.csv\n")
cat("\n# - SE_WL.csv\n")
cat("\n# - SE_EX.csv\n")
cat("\n# - SA_CompareWL&EX.csv\n")
cat("\n# - SA_WL.csv\n")
cat("\n# - SA_EX.csv\n")
cat("\n# - NegoF_CompareWL&EX.csv\n")
cat("\n# - NegoF_ALL.csv\n")
cat("\n# - NegoF_WL.csv\n")
cat("\n# - NegoF_EX.csv\n")
cat("\n# - NegoResult_CompareWL&EX.csv\n")
cat("\n# - NegoResult_ALL.csv\n")
cat("\n# - NegoResult_WL.csv\n")
cat("\n# - NegoResult_EX.csv\n")
cat("\n# - NegoKnowledge_CompareWL&EX.csv\n")
cat("\n# - NegoKnowledge_ALL.csv\n")
cat("\n# - NegoKnowledge_WL.csv\n")
cat("\n# - NegoKnowledge_EX.csv\n")
cat("\n# - Utility.csv\n")

cat("\n#################### Self-efficacy ####################\n")
cat("\n# File with the self-efficacy data of waitinglist and experiment group\n")
cat("\n# Data originally obtained from the file SE_CompareWL&EX.csv\n")
cat("\n# data fields\n")
cat("\n#1 ID: Participants ID\n")
cat("\n#2 Group: waitinglist or experiment group\n")
cat("\n#3 Session: Pre or Post\n")
cat("\n#4 Score: the self-efficacy data\n")

SE_WLwithEX <- read.csv("SE_CompareWL&EX.csv", header = TRUE)
SE_WLwithEX$Session<-factor(SE_WLwithEX$Session,levels = c("Pre","Post"))
SE_Waitinglist <- read.csv("SE_WL.csv", header = TRUE)
SE_Experiment <- read.csv("SE_EX.csv", header = TRUE)
SE_Experiment_WS<-subset(SE_Experiment,Group=="EWS" )
SE_Experiment_WOS<-subset(SE_Experiment,Group=="EWOS" )

cat("\n# File with the self-efficacy data of all training sessions\n")
cat("\n# Data originally obtained from the file SE_With aLL sessions.csv\n")
cat("\n# data fields\n")
cat("\n#1 SE:  Self-efficacy data measured before the training session (Pre-measurement data)\n")
cat("\n#2 SE1: Self-efficacy data measured after the first training session \n")
cat("\n#3 SE2: Self-efficacy data measured after the second training session\n")
cat("\n#4 SE3: Self-efficacy data measured after the third training session (Post-measurement data)\n")
cat("\n#5 SE_follow: Self-efficacy data measured two weeks after all the training sessions (Follow-up measurement data)\n")

SE_AllSessions <- read.csv("SE_With aLL sessions.csv", header = TRUE)
SE_AllSessions$SE<-as.numeric(as.character(SE_AllSessions$SE))
SE_AllSessions$SE1<-as.numeric(as.character(SE_AllSessions$SE1))
SE_AllSessions$SE2<-as.numeric(as.character(SE_AllSessions$SE2))
SE_AllSessions$SE3<-as.numeric(as.character(SE_AllSessions$SE3))
SE_AllWS<-subset(SE_AllSessions,Group=="WS")
SE_AllWOS<-subset(SE_AllSessions,Group=="WOS")

cat("\n################# Negotiation knowledge ################# \n") 
cat("\n# File with the negotiation knowledge of participants from waitinglist and training group\n")
cat("\n# Data originally obtained from the file NegoKnowledge_CompareWL&EX.csv\n")
cat("\n#1 ID: Participants ID\n") 
cat("\n#2 Group: waitinglist or experiment group(with self-motivation or without self-motivation)\n") 
cat("\n#3 Session: Pre or Post\n") 
cat("\n#4 Score: the negotiation knowledge test data\n") 

NegoKnowledge_WLwithEX <- read.csv("NegoKnowledge_CompareWL&EX.csv", header = TRUE)
NegoKnowledge_WLwithEX$Session<-factor(NegoKnowledge_WLwithEX$Session,levels = c("Pre","Post"))
NegoKnowledge_Waitinglist <- read.csv("NegoKnowledge_WL.csv", header = TRUE)
NegoKnowledge_Experiment <- read.csv("NegoKnowledge_EX.csv", header = TRUE)


cat("\n# File with the negotiation knowledge of participants from both training with self-motivation and without self-motivation group\n")
cat("\n# Data originally obtained from the file NegoKnowledge_ALL.csv\n")
cat("\n#1 ID: Participants ID\n")
cat("\n#2 Pre: pre-measurement data\n")
cat("\n#3 Post: post-measurement data\n")
cat("\n#4 FollowUp: followUp-measurement data\n")
cat("\n#5 Group: with self-motivation or without self-motivation\n")
NegoKnowledge_AllSessions <- read.csv("NegoKnowledge_ALL.csv", header = TRUE)
NegoKnowledge_AllSessions$Pre<-as.numeric(as.character(NegoKnowledge_AllSessions$Pre))
NegoKnowledge_AllSessions$Post<-as.numeric(as.character(NegoKnowledge_AllSessions$Post))
NegoKnowledge_AllSessions$FollowUp<-as.numeric(as.character(NegoKnowledge_AllSessions$FollowUp))
NegoKnowledge_AllWS<-subset(NegoKnowledge_AllSessions,Group=="WS")
NegoKnowledge_AllWOS<-subset(NegoKnowledge_AllSessions,Group=="WOS")


cat("\n################# Negotiation behaviour and performance #################\n")

cat("\n####### Negotiation Frequency ######\n")
cat("\n# File with the negotiation frequency data of participants from waitinglist and training group\n")
cat("\n# Data originally obtained from the file NegoF_CompareWL&EX.csv\n")
cat("\n#1 ID: Participants ID\n")
cat("\n#2 Group: waitinglist or experiment group(with self-motivation or without self-motivation)\n")
cat("\n#3 Session: Pre or Post\n")
cat("\n#4 Score: the negotiation Frequency data\n")

NegoF_WLwithEX <- read.csv("NegoF_CompareWL&EX.csv", header = TRUE)
cat("\n## Compare waitinglist and training group\n") 
NegoF_Waitinglist <- read.csv("NegoF_WL.csv", header = TRUE)
NegoF_Experiment <- read.csv("NegoF_EX.csv", header = TRUE)

cat("\n# File with the negotiation frequency data of participants from both training with self-motivation and  without self-motivation group\n")
cat("\n# Data originally obtained from the file NegoF_ALL.csv\n")
cat("\n#1 ID: Participants ID\n")
cat("\n#2 Pre: pre-measurement data\n")
cat("\n#3 Post: post-measurement data\n")
cat("\n#4 FollowUp: followUp-measurement data\n")
cat("\n#5 Group: with self-motivation or without self-motivation\n")

NegoF_AllSessions <- read.csv("NegoF_ALL.csv", header = TRUE)
NegoF_AllSessions$Pre<-as.numeric(as.character(NegoF_AllSessions$Pre))
NegoF_AllSessions$Post<-as.numeric(as.character(NegoF_AllSessions$Post))
NegoF_AllSessions$FollowUp<-as.numeric(as.character(NegoF_AllSessions$FollowUp))
NegoF_AllWS<-subset(NegoF_AllSessions,Group=="WS")
NegoF_AllWOS<-subset(NegoF_AllSessions,Group=="WOS")

cat("\n####### Negotiation satisfaction #######\n")
cat("\n# File with the negotiation satisfaction data of participants from both waitinglist or experiment group\n")
cat("\n# Data originally obtained from the file SA_CompareWL&EX.csv\n")
cat("\n#1 ID: Participants ID\n")
cat("\n#2 Group: waitinglist or experiment group (with self-motivation or without self-motivation)\n")
cat("\n#3 Session: Pre or Post\n")
cat("\n#4 Score: the negotiation satisfaction data\n")

SA_WLwithEX <- read.csv("SA_CompareWL&EX.csv", header = TRUE)
SA_WLwithEX$Session<-factor(SA_WLwithEX$Session,levels = c("Pre","Post"))
SA_Waitinglist <- read.csv("SA_WL.csv", header = TRUE)
SA_Experiment <- read.csv("SA_EX.csv", header = TRUE)
SA_Experiment_WS<-subset(SA_Experiment,Group=="EWS" )
SA_Experiment_WOS<-subset(SA_Experiment,Group=="EWOS" )

cat("\n# File with the negotiation satisfaction data of participants from both training with self-motivation and  without self-motivation group\n")
cat("\n# Data originally obtained from the file SA_ALL.csv\n")
cat("\n#1 ID: Participants ID\n")
cat("\n#2 Pre: pre-measurement data\n")
cat("\n#3 Post: post-measurement data\n")
cat("\n#4 FollowUp: followUp-measurement data\n")
cat("\n#5 Group: with self-motivation or without self-motivation\n")
SA_AllSessions <- read.csv("SA_ALL.csv", header = TRUE)
SA_AllSessions$Pre<-as.numeric(as.character(SA_AllSessions$Pre))
SA_AllSessions$Post<-as.numeric(as.character(SA_AllSessions$Post))
SA_AllSessions$FollowUp<-as.numeric(as.character(SA_AllSessions$FollowUp))
SA_AllWS<-subset(SA_AllSessions,Group=="WS")
SA_AllWOS<-subset(SA_AllSessions,Group=="WOS")

cat("\n################# Negotiation Result #################\n")
cat("\n# File with the negotiation result data of participants from both waitinglist or experiment group\n")
cat("\n# Data originally obtained from the file NegoResult_CompareWL&EX.csv\n")
cat("\n#1 ID: Participants ID\n")
cat("\n#2 Group: Waitinglist or experiment group (with self-motivation or without self-motivation)\n")
cat("\n#3 Session: Pre or Post\n")
cat("\n#4 Score: the negotiation result data\n")
NegoResult_WLwithEX <- read.csv("NegoResult_CompareWL&EX.csv", header = TRUE)
NegoResult_WLwithEX$Session<-factor(NegoResult_WLwithEX$Session,levels = c("Pre","Post"))
NegoResult_Waitinglist <- read.csv("NegoResult_WL.csv", header = TRUE)
NegoResult_Experiment <- read.csv("NegoResult_EX.csv", header = TRUE)

cat("\n# File with the negotiation result data of participants from both training with self-motivation and  without self-motivation group\n")
cat("\n# Data originally obtained from the file NegoResult_ALL.csv\n")
cat("\n#1 ID: Participants ID\n")
cat("\n#2 Pre: pre-measurement data\n")
cat("\n#3 Post: post-measurement data\n")
cat("\n#4 FollowUp: followUp-measurement data\n")
cat("\n#5 Group: with self-motivation or without self-motivation\n")
NegoResult_AllSessions <- read.csv("NegoResult_ALL.csv", header = TRUE)
NegoResult_AllSessions$Pre<-as.numeric(as.character(NegoResult_AllSessions$Pre))
NegoResult_AllSessions$Post<-as.numeric(as.character(NegoResult_AllSessions$Post))
NegoResult_AllSessions$FollowUp<-as.numeric(as.character(NegoResult_AllSessions$FollowUp))
NegoResult_AllWS<-subset(NegoResult_AllSessions,Group=="WS")
NegoResult_AllWOS<-subset(NegoResult_AllSessions,Group=="WOS")

cat("\n################# Utility #################\n")
cat("\n# File with the utility data of the system from all participants\n")
cat("\n# Data orignally obtained from the file Utility.csv\n")
cat("\n# ID: Participants ID\n") 
cat("\n# Q1-Q7: the rating score of each item\n") 
cat("\n# Group: with self-motivation or without self-motivation\n") 

Utility_ALL <- read.csv("Utility.csv", header = TRUE)
Utility_Satisfaction<-Utility_ALL[,c(1:4,9)]
Utility_Effectiveness<-Utility_ALL[,c(1,5:9)]
Utility_Satisfaction$Score<-rowMeans(Utility_Satisfaction[2:4])
Utility_Effectiveness$Score<-rowMeans(Utility_Effectiveness[2:5])
Utility_SatisfactionSub<-Utility_Satisfaction[,c(1,5:6)]
Utility_EffectivenessSub<-Utility_Effectiveness[,c(1,6:7)]
Utility_Satisfaction_WS<-subset(Utility_Satisfaction, Group=="WS")
Utility_Satisfaction_WOS<-subset(Utility_Satisfaction, Group=="WOS")
Utility_Effectiveness_WS<-subset(Utility_Effectiveness, Group=="WS")
Utility_Effectiveness_WOS<-subset(Utility_Effectiveness, Group=="WOS")

cat("\n#################### Normal distribution test ####################\n")

cat("\n###### Demographic characteristics ######")
cat("\n### Age ####\n")
cat("\n1. waitlist and training group\n")
stem(ParticipantInfoWL$Age)
stem(ParticipantInfoDirectEX$Age)
cat("\n### The data of participants' age from both waitlist and training group is normally distributed, therefore t-test will be used.\n")
cat("\n2. training with self-motivation and without self-motivation group\n")
stem(ParticipantInfoInterventionWS$Age)
stem(ParticipantInfoInterventionWOS$Age)
cat("\n# The data of participants' age from both training with self-motivation and without self-motivation group is normally distributed, therefore t.test will be used.\n")

cat("\n###### Self-efficacy ######\n")
cat("\n1. waitlist and training group\n")
stem(SE_Waitinglist$Pre)
stem(SE_Experiment$Pre)
stem((SE_Waitinglist$Post-SE_Waitinglist$Pre))
stem((SE_Experiment$Post-SE_Experiment$Pre))
cat("\n### The data of participants' self-efficacy from waitlist and training group is normally distributed, therefore t-test will be used.\n")

cat("\n2. training with self-motivation and without self-motivation group\n")
stem(SE_AllWOS$SE)
stem(SE_AllWS$SE)
stem(SE_AllWOS$SE1)
stem(SE_AllWS$SE1)
stem(SE_AllWOS$SE2)
stem(SE_AllWS$SE2)
stem(SE_AllWOS$SE3)
stem(SE_AllWS$SE3)
stem(SE_AllWOS$SE_follow)
stem(SE_AllWS$SE_follow)
cat("\n### The data of participants' self-efficacy from training with self-motivation and without self-motivation group is normally distributed, therefore t-test will be used.\n")

cat("\n###### Negotiation knowledge ######\n")
cat("\n1. waitlist and training group\n")
stem(NegoKnowledge_Waitinglist$Pre)
stem(NegoKnowledge_Experiment$Pre)
stem((NegoKnowledge_Waitinglist$Post-NegoKnowledge_Waitinglist$Pre))
stem((NegoKnowledge_Experiment$Post-NegoKnowledge_Experiment$Pre))
cat("\n### The data of participants' negotiation knowledge from waitlist and training group is normally distributed, therefore t-test will be used.\n")

cat("\n2. training with self-motivation and without self-motivation group\n")
stem(NegoKnowledge_AllWS$Pre)
stem(NegoKnowledge_AllWS$Post)
stem(NegoKnowledge_AllWS$FollowUp)
stem(NegoKnowledge_AllWOS$Pre)
stem(NegoKnowledge_AllWOS$Post)
stem(NegoKnowledge_AllWOS$FollowUp)
cat("\n### The data of participants' negotiation knowledge from training with self-motivation and without self-motivation group is normally distributed, therefore t-test will be used.\n")


cat("\n###### Negotiation behaviour and performance ######\n")

cat("\n###### Negotiation Frequency ######\n")
cat("\n1. waitlist and training group\n")
stem(NegoF_Waitinglist$Post) #shapiro.test(NegoF_Waitinglist$Post)
stem(NegoF_Waitinglist$Pre) #shapiro.test(NegoF_Waitinglist$Pre)
stem(NegoF_Experiment$Post) #shapiro.test(NegoF_Experiment$Post)
stem(NegoF_Experiment$Pre) #shapiro.test(NegoF_Experiment$Pre)
stem((NegoF_Waitinglist$Post-NegoF_Waitinglist$Pre)) #shapiro.test((NegoF_Waitinglist$Post-NegoF_Waitinglist$Pre))
stem((NegoF_Experiment$Post-NegoF_Experiment$Pre)) #shapiro.test((NegoF_Experiment$Post-NegoF_Experiment$Pre))
cat("\n### The data of participants' negotiation frequency from waitlist and training group is not normally distributed, therefore Wilcoxon test will be used.\n")

cat("\n2. training with self-motivation and without self-motivation group\n")
stem(NegoF_AllWS$Pre) 
stem(NegoF_AllWOS$Pre)
stem(NegoF_AllWS$Post)
stem(NegoF_AllWS$FollowUp) 
stem(NegoF_AllWOS$Post)
stem(NegoF_AllWOS$FollowUp)
cat("\n### The data of participants' negotiation frequency from training with self-motivation and without self-motivation group is not normally distributed, therefore Wilcoxon test will be used.\n")


cat("\n###### Negotiation satisfaction ######\n")

cat("\n1. waitlist and training group\n")
stem(SA_Waitinglist$Pre)
stem(SA_Experiment$Pre)
stem(SA_Waitinglist$Post)
stem(SA_Waitinglist$Pre)
stem(SA_Experiment$Post)
stem(SA_Experiment$Pre)
stem(SA_Experiment$Post-SA_Experiment$Pre)
stem(SA_Waitinglist$Post-SA_Waitinglist$Pre)
cat("\n### The data of participants' negotiation satisfaction from both waitinglist and training group is not normally distributed, therefore Wilcoxon test will be used.\n")

cat("\n2. training with self-motivation and without self-motivation group\n")
stem(SA_AllWS$Pre) 
stem(SA_AllWS$Post)
stem(SA_AllWS$FollowUp) 
stem(SA_AllWOS$Pre)
stem(SA_AllWOS$Post)
stem(SA_AllWOS$FollowUp)
stem(SA_AllWS$Post-SA_AllWS$Pre)
stem(SA_AllWOS$Post-SA_AllWOS$Pre)
cat("\n### The data of participants' negotiation satisfaction from both with self-motivation and without self-motivation is not normally distributed, therefore Wilcoxon test will be used.\n")

cat("\n###### Negotiation Result ######\n")

cat("\n1. waitlist and training group\n")
stem(NegoResult_Waitinglist$Post)#shapiro.test(NegoResult_Waitinglist$Post)
stem(NegoResult_Waitinglist$Pre)#shapiro.test(NegoResult_Waitinglist$Pre)
stem(NegoResult_Experiment$Post)#shapiro.test(NegoResult_Experiment$Post)
stem(NegoResult_Experiment$Pre)#shapiro.test(NegoResult_Experiment$Pre)
stem((NegoResult_Waitinglist$Post-NegoResult_Waitinglist$Pre)) #shapiro.test((NegoResult_Waitinglist$Post-NegoResult_Waitinglist$Pre))
stem((NegoResult_Experiment$Post-NegoResult_Experiment$Pre)) #shapiro.test((NegoResult_Experiment$Post-NegoResult_Experiment$Pre))
cat("\n### The data of participants' negotiation result from waitlist and training group is not normally distributed, therefore Wilcoxon test will be used.\n")

cat("\n2. training with self-motivation and without self-motivation group\n")
stem(NegoResult_AllWS$Pre) 
stem(NegoResult_AllWS$Post)
stem(NegoResult_AllWS$FollowUp) 
stem(NegoResult_AllWOS$Pre)
stem(NegoResult_AllWOS$Post)
stem(NegoResult_AllWOS$FollowUp)
cat("\n### The data of participants' negotiation result from waitlist and training group is not normally distributed, therefore Wilcoxon test will be used.\n")

cat("\nn###### Utility n######\n")
stem(Utility_Satisfaction_WS$Score)
stem(Utility_Satisfaction_WOS$Score)
stem(Utility_Effectiveness_WS$Score)
stem(Utility_Effectiveness_WOS$Score)
cat("\n### The data of participants' utility_satisfaction and utility_effectiveness data from training with self-motivation and without self-motivation group is normally distributed, therefore t-test will be used.\n")

######### stop redireting output.
sink()
cat("\nOutput of the analysis can be found back in file output_analysisI_NormalDistributionTestResults.txt")